;; v_togtc.lsp -- toggles drawing editing timer on/off
;; Copyright 1996, VCad
;; If a custom status line with time clock status display
;; is not being used, ignor the following info:
   ;; With time-clock status set up, the variable  g_tu'
   ;; is set.  If set, toggling the time clock sets the
   ;; Acad-user-variable  'USERS1' to a string value for 
   ;; status display. The Acad-variable used, as well as the  
   ;; string display may be changed--they must be edited in  
   ;; 1) this file, 2) the modemacro file being used 
   ;; (v_mode.lsp or v_mods.lsp), and 3) v_tmset.lsp.
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun togtc ( / tlap ttim)
  (setq tlap (getvar "TDUSRTIMER"))
  (setq ttim (getvar "CDATE"))
  (while (< (getvar "CDATE") (+ 0.00000005 ttim)))
  (if (= tlap (getvar "TDUSRTIMER"))
    (progn
      (if (/= nil g_tu)
        (setvar "USERS1" "T=On ")
      ) 
      (command "time" "on" "")
      (prompt "\nTimer set: ON")
    )
    (progn
      (if (/= nil g_tu)
        (setvar "USERS1" "T=Off")
      )
      (command "time" "OFF" "")
      (prompt "\nTimer set: OFF")
    )
  )
  (graphscr) 
  (princ)
) ;; end togtc

